/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GoblinTraderEntity
extends AbstractGoblinEntity {
    public GoblinTraderEntity(World worldIn) {
        super((EntityType<? extends CreatureEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()), worldIn);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("goblintraders", "textures/entity/goblin_trader.png");
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.func_213706_dY();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ITrade>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                List<VillagerTrades.ITrade> trades = tradeMap.get((Object)rarity);
                int min = rarity.getMaximum().apply(trades, this.field_70146_Z);
                int max = rarity.getMaximum().apply(trades, this.field_70146_Z);
                this.addTrades(offers, trades, Math.max(min, max), rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((IItemProvider)Items.field_151034_e);
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.COMMON.goblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.COMMON.goblinTrader.canAttackBack.get();
    }

    public int func_70627_aG() {
        return (Integer)Config.COMMON.goblinTrader.gruntNoiseInterval.get();
    }
}

